<?php

namespace App\Models\Tenant;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class CashierShiftOrder extends Model 
{

    protected $table = 'cashier_shift_orders';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function cashierShift()
    {
        return $this->belongsTo('App\Models\Tenant\CashierShift');
    }

    public function order()
    {
        return $this->belongsTo('App\Models\Tenant\Order');
    }

}